library proc_keep;

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Keep Process Module for Lightning.
 *
 * The Initial Developer of the Original Code is
 * Tomsoft.
 * Portions created by Tomsoft are Copyright (C) 2009
 * Tomsoft. All Rights Reserved.
 *
 * Contributor(s):
 *   Tommy Sools <tom@sools.com>
 *
 * ***** END LICENSE BLOCK ***** *)

{$IMAGEBASE $41400000}

uses
  SysUtils,
  Windows,
  Classes,
  StdCtrls,
  Spin,
  Graphics,
  common in '..\common.pas';

{$R *.RES}

type
  TDetails = class(TObject)
    gbDetails:  TGroupBox;
    lKeepTime:  TLabel;
    seKeepTime: TSpinEdit;
    procedure seKeepTimeChange(Sender: TObject);
  public
    pulsed:    Boolean;
    startTime: Int64;
    keep:      Cardinal;
  end;

procedure TDetails.seKeepTimeChange(Sender: TObject);
begin
  keep := seKeepTime.Value;
end;

function init(name: PChar; nameLength: DWORD): DWORD; cdecl;
begin
  Result := return('PKeep|Pulse Control', name, nameLength);
  tickInit;
end;

procedure finish(); cdecl;
begin
  //
end;

function create(controlHandle: THandle): PLightningModule; cdecl;
var
  myDetails: TDetails;
begin
  New(Result);
  with Result^ do
  begin
    handle        := controlHandle;
    title         := 'Keep';
    settings      := True;
    width         := -1;
    height        := -1;
    inputTop      := -1;
    infoTop       := -1;
    outputTop     := -1;
    inputs        := 1;
    outputs       := 1;
    inputTooltip  := 'Status';
    outputTooltip := 'Keep status';
    myDetails     := TDetails.Create;
    details       := myDetails;
    reserved      := nil;
  end;
  with myDetails do
  begin
    startTime := 0;
    pulsed    := False;
    keep      := 50;
  end;
end;

procedure destroy(lightningModule: PLightningModule); cdecl;
begin
  TDetails(lightningModule^.details).Free;
  Dispose(lightningModule);
end;

function action(lightningModule: PLightningModule; input, output: Integer; inputConnected, outputConnected: PChar; var bridge: TSpectrum): Boolean; cdecl;
var
  details: TDetails;
  outcome: Boolean;
begin
  details := TDetails(lightningModule.details);
  outcome := True;
  if spectrumAverage(bridge, fftMin, fftMax) > enabledBoundary then
  begin
    if not(details.pulsed) then
    begin
      details.pulsed    := True;
      details.startTime := tickCount;
    end;
  end
  else
    if details.pulsed then
    begin
      if tickCount - details.startTime >= details.keep then
      begin
        details.pulsed := False;
        outcome := False;
      end;
    end
    else
      outcome := False;
  if outcome then
    createSpectrum(bridge, levelMax)
  else
    createSpectrum(bridge, levelMin);
  Result := True;
end;

procedure show(lightningModule: PLightningModule; handle: THandle); cdecl;
begin
  with TDetails(lightningModule.details) do
  begin
    gbDetails              := TGroupBox.Create(nil);
    gbDetails.Top          := detailsTop;
    gbDetails.Left         := detailsLeft;
    gbDetails.Width        := detailsWidth;
    gbDetails.Height       := detailsHeight;
    gbDetails.Ctl3D        := True;
    gbDetails.Color        := clBtnFace;
    gbDetails.Caption      := 'Keep Settings';
    lKeepTime              := TLabel.Create(gbDetails);
    lKeepTime.AutoSize     := True;
    lKeepTime.Top          := 20;
    lKeepTime.Left         := 8;
    lKeepTime.Caption      := 'Keep time (ms):';
    lKeepTime.Parent       := gbDetails;
    seKeepTime             := TSpinEdit.Create(gbDetails);
    seKeepTime.Top         := 40;
    seKeepTime.Left        := 8;
    seKeepTime.MinValue    := 0;
    seKeepTime.MaxValue    := 10000;
    seKeepTime.Increment   := 10;
    seKeepTime.Value       := keep;
    seKeepTime.OnChange    := seKeepTimeChange;
    seKeepTime.Parent      := gbDetails;
    gbDetails.ParentWindow := handle;
  end;
end;

procedure hide(lightningModule: PLightningModule); cdecl;
begin
  with TDetails(lightningModule.details) do
  begin
    seKeepTime.Free;
    lKeepTime.Free;
    gbDetails.Free;
  end;
end;

procedure open(lightningModule: PLightningModule; settings: PChar); cdecl;
var
  bString: string;
begin
  bString := settings;
  bString := parse(bString, ',');
  if bString <> '' then
    TDetails(lightningModule.details).keep := StrToInt(bString);
end;

function save(lightningModule: PLightningModule; settings: PChar; settingsLength: DWORD): DWORD; cdecl;
begin
  Result := return(IntToStr(TDetails(lightningModule.details).keep), settings, settingsLength);
end;

exports
  init, finish, create, destroy, action, show, hide, open, save;

end.
