library proc_connection;

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Connection Process Module for Lightning.
 *
 * The Initial Developer of the Original Code is
 * Tomsoft.
 * Portions created by Tomsoft are Copyright (C) 2011
 * Tomsoft. All Rights Reserved.
 *
 * Contributor(s):
 *   Tommy Sools <tom@sools.com>
 *
 * ***** END LICENSE BLOCK ***** *)

{$IMAGEBASE $41330000}

uses
  SysUtils,
  Windows,
  common in '..\common.pas';

{$R *.RES}

function  init(name: PChar; nameLength: DWORD): DWORD; cdecl;
begin
  Result := return('PConnection|Panels', name, nameLength);
end;

procedure finish(); cdecl;
begin
  //
end;

function  create(controlHandle: THandle): PLightningModule; cdecl;
begin
  New(Result);
  with Result^ do
  begin
    handle        := controlHandle;
    title         := 'C';
    settings      := False;
    width         := -1;
    height        := 56;
    inputTop      := -1;
    infoTop       := 64;
    outputTop     := 32;
    inputs        := 1;
    outputs       := 1;
    inputTooltip  := 'Spectrum';
    outputTooltip := 'Spectrum';
    details       := nil;
    reserved      := nil;
  end;
end;

procedure destroy(lightningModule: PLightningModule); cdecl;
begin
  Dispose(lightningModule);
end;

function  action(lightningModule: PLightningModule; input, output: Integer; inputConnected, outputConnected: PChar; var bridge: TSpectrum): Boolean; cdecl;
begin
  Result := True;
end;

procedure show(lightningModule: PLightningModule; handle: THandle); cdecl;
begin
  //
end;

procedure hide(lightningModule: PLightningModule); cdecl;
begin
  //
end;

procedure open(lightningModule: PLightningModule; settings: PChar); cdecl;
begin
  //
end;

function  save(lightningModule: PLightningModule; settings: PChar; settingsLength: DWORD): DWORD; cdecl;
begin
  Result := return('', settings, settingsLength);
end;

exports
  init, finish, create, action, show, hide, open, save, destroy;

end.
